@if( ! empty( $lat ) && ! empty( $lng ) )
    <div class="ulz-mod-listing ulz-mod-listing-location @if( $show_address && $address ) ulz--has-address @endif" data-type="location">
        @if( ! empty( $name ) )
            <h4>{{ $name }}</h4>
        @endif
        <div class="ulz-map-outer">
            <div class="ulz-map" data-lat="{{ $lat }}" data-lng="{{ $lng }}">
                @if( ! $api_key )
                    <span class="ulz-none">{{ $strings->no_api }}</span>
                @endif
            </div>
            <div class="ulz-map-zoom">
                <a href="#" class="ulz--zoom-in" data-action="explore-map-zoom-in"><i class="fas fa-plus"></i></a>
                <a href="#" class="ulz--zoom-out" data-action="explore-map-zoom-out"><i class="fas fa-minus"></i></a>
            </div>
            <div class="ulz-mod-listing-marker-content ulz-none">
                <span class="ulz-mod-listing-marker">
                    {!! utillz_core()->icon->get( $icon, $set ) !!}
                </span>
            </div>
            @if( $show_address && $address )
                <div class="ulz--address">
                    <i class="ulz--icon fas fa-map-marker-alt"></i>
                    <a href="{{ add_query_arg( [ 'api' => 1, 'query' => urlencode( $address ) ], 'https://www.google.com/maps/search/' ) }}" target="_blank">
                        {{ $address }}
                    </a>
                </div>
            @endif
        </div>
    </div>
@else
    <div class="ulz-mod-content">
        <div class="ulz-not-specified">
            <i class="fas fa-map-marker-alt"></i>
            <p>{{ $strings->not_specified }}</p>
        </div>
    </div>
@endif
